function [N_p,J_p,L_p,H_p] = Partial_observer(A,B,F,D1,C,D2)

[n,m] = size(B);
[~,r] = size(D1(:,1));
[p,~] = size(C);

% Augmented system
A_bar = [A zeros(n,r) F; zeros(r,n+2*r); zeros(r,n) eye(r) zeros(r,r)]; 
B_bar = [B; zeros(2*r,m)]; 
D1_bar1 = [D1(:,2); zeros(2*r,1)];

C_bar = [C zeros(p,2*r)];
D2_bar = D2;
Cs1 = eye(n+2*r);

H_p = D1_bar1*inv((C_bar*D1_bar1)'*(C_bar*D1_bar1))*(C_bar*D1_bar1)';
Xi_p = eye(n+2*r) - H_p*C_bar;

% Solve LMIs using the Matlab LMI toolbox
gamma = 1.0e-1;

setlmis([])

Q_p=lmivar(1, [n+2*r 1] );
M_p=lmivar(2, [n+2*r p] );

% LMI1
lmiterm([ 1 1 1  Q_p] , 1, Xi_p*A_bar, ' s');
lmiterm([ 1 1 1  M_p] , -1, C_bar, ' s');
lmiterm([ 1 1 2  Q_p] , -1, H_p*D2_bar);
lmiterm([ 1 1 3  M_p] , -1, D2_bar);
lmiterm([ 1 1 4  0] , Cs1' );

lmiterm([ 1 2 2  0] ,-gamma^2);
lmiterm([ 1 3 3  0] ,-gamma^2);
lmiterm([ 1 4 4 0] , -1);

%LMI2
lmiterm([-2 1 1  Q_p], 1, 1);


lmisys = getlmis;

[tmin,xfeas ] = feasp(lmisys);
Q_p = dec2mat(lmisys, xfeas, Q_p);
M_p = dec2mat(lmisys, xfeas, M_p);

L1 = inv(Q_p)*M_p;

N_p = Xi_p*A_bar - L1*C_bar;
J_p = Xi_p*B_bar;
L2 = N_p*H_p;
L_p = L1 + L2;


